/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.List;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.storage.sPartition;
import oracle.ops.verification.framework.util.VerificationUtil;

public class PathDiskInfo
extends sPartition
implements StorageConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private String m_node = null;
    private String m_fileSystem = null;
    private String m_mountPathOrigin = null;
    private String m_origPath = null;
    private Result m_result = null;
    private String m_sign = null;

    public PathDiskInfo(String node, String origPath, sDisk disk, String partNum, String fileSystem, String mountPathOrigin) throws InvalidPathException {
        super(disk, partNum);
        if (!VerificationUtil.isStringGood(origPath)) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", true));
        }
        this.m_node = node;
        this.m_sign = disk.getSignature();
        this.m_result = new Result(node);
        this.m_origPath = origPath;
        this.m_mountPathOrigin = mountPathOrigin;
        this.m_fileSystem = fileSystem;
    }

    public PathDiskInfo(String node, String origPath, sDisk disk, String partNum, String fileSystem) throws InvalidPathException {
        this(node, origPath, disk == null ? new sDisk(origPath, node, "") : disk, partNum, fileSystem, null);
    }

    public PathDiskInfo(String node, String origPath, sDisk disk, String partNum) throws InvalidPathException {
        this(node, origPath, disk == null ? new sDisk(origPath, node, "") : disk, partNum, null, null);
    }

    public boolean checkSameMountPoint(PathDiskInfo pathInfo) {
        if (pathInfo == null) {
            return false;
        }
        if (pathInfo.getNode() != null && !pathInfo.getNode().equalsIgnoreCase(this.m_node)) {
            return false;
        }
        return pathInfo.getName().equalsIgnoreCase(this.getName()) && pathInfo.getSignature().equals(this.getSignature());
    }

    public String getMountPoint() {
        if (!VerificationUtil.isStringGood(this.m_mountPathOrigin)) {
            return this.getName();
        }
        return this.m_mountPathOrigin;
    }

    public String getMountPathOrigin() {
        return this.m_mountPathOrigin;
    }

    @Override
    public boolean isRaw() {
        return this.m_fileSystem == null || this.m_fileSystem.trim().equalsIgnoreCase("RAW");
    }

    public String getFileSystem() {
        return this.m_fileSystem;
    }

    @Override
    public String getOrigPath() {
        return this.m_origPath;
    }

    @Override
    public void setOrigPath(String origPath) {
        this.m_origPath = origPath;
    }

    @Override
    public String getNode() {
        return this.m_node;
    }

    public List<VerificationError> getErrors() {
        return this.m_result.getErrors();
    }

    public void addErrorDescription(ErrorDescription errorDesc) {
        this.m_result.addErrorDescription(errorDesc);
    }

    public void addErrorDescription(List<VerificationError> errorDescList) {
        this.m_result.addErrorDescription(errorDescList);
    }

    public void setStatus(int status) {
        this.m_result.setStatus(status);
    }

    public int getStatus() {
        return this.m_result.getStatus();
    }

    public Result getResult() {
        return this.m_result;
    }

    @Override
    public String getSignature() {
        return this.m_sign;
    }
}

